/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LazyFileOutputStream
extends OutputStream {
    private FileOutputStream fos;
    private File file;
    private boolean append;
    private boolean alwaysCreate;
    private boolean opened = false;
    private boolean closed = false;

    public LazyFileOutputStream(String string) {
        this(string, false);
    }

    public LazyFileOutputStream(String string, boolean bl) {
        this(new File(string), bl);
    }

    public LazyFileOutputStream(File file) {
        this(file, false);
    }

    public LazyFileOutputStream(File file, boolean bl) {
        this(file, bl, false);
    }

    public LazyFileOutputStream(File file, boolean bl, boolean bl2) {
        this.file = file;
        this.append = bl;
        this.alwaysCreate = bl2;
    }

    public void open() throws IOException {
        this.ensureOpened();
    }

    public synchronized void close() throws IOException {
        if (this.alwaysCreate && !this.closed) {
            this.ensureOpened();
        }
        if (this.opened) {
            this.fos.close();
        }
        this.closed = true;
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpened();
        this.fos.write(byArray, n, n2);
    }

    public synchronized void write(int n) throws IOException {
        this.ensureOpened();
        this.fos.write(n);
    }

    private synchronized void ensureOpened() throws IOException {
        if (this.closed) {
            throw new IOException(this.file + " has already been closed.");
        }
        if (!this.opened) {
            this.fos = new FileOutputStream(this.file.getAbsolutePath(), this.append);
            this.opened = true;
        }
    }
}

