/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.util.TimeoutObserver;

public class Watchdog
implements Runnable {
    private Vector observers = new Vector(1);
    private long timeout = -1L;
    private boolean stopped = false;

    public Watchdog(long l) {
        if (l < 1L) {
            throw new IllegalArgumentException("timeout lesser than 1.");
        }
        this.timeout = l;
    }

    public void addTimeoutObserver(TimeoutObserver timeoutObserver) {
        this.observers.addElement(timeoutObserver);
    }

    public void removeTimeoutObserver(TimeoutObserver timeoutObserver) {
        this.observers.removeElement(timeoutObserver);
    }

    protected final void fireTimeoutOccured() {
        Enumeration enumeration = this.observers.elements();
        while (enumeration.hasMoreElements()) {
            ((TimeoutObserver)enumeration.nextElement()).timeoutOccured(this);
        }
    }

    public synchronized void start() {
        this.stopped = false;
        Thread thread = new Thread((Runnable)this, "WATCHDOG");
        thread.setDaemon(true);
        thread.start();
    }

    public synchronized void stop() {
        this.stopped = true;
        this.notifyAll();
    }

    public synchronized void run() {
        long l;
        long l2 = System.currentTimeMillis() + this.timeout;
        while (!this.stopped && l2 > (l = System.currentTimeMillis())) {
            try {
                this.wait(l2 - l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!this.stopped) {
            this.fireTimeoutOccured();
        }
    }
}

