/*
 * Decompiled with CFR 0.152.
 */
package net.jeremybrooks.knicker;

import java.io.StringWriter;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.jeremybrooks.knicker.DTOBuilder;
import net.jeremybrooks.knicker.KnickerException;
import net.jeremybrooks.knicker.Util;
import net.jeremybrooks.knicker.dto.AuthenticationToken;
import net.jeremybrooks.knicker.dto.Definition;
import net.jeremybrooks.knicker.dto.Example;
import net.jeremybrooks.knicker.dto.FrequencySummary;
import net.jeremybrooks.knicker.dto.Phrase;
import net.jeremybrooks.knicker.dto.Pronunciation;
import net.jeremybrooks.knicker.dto.PunctuationFactor;
import net.jeremybrooks.knicker.dto.Related;
import net.jeremybrooks.knicker.dto.SearchResult;
import net.jeremybrooks.knicker.dto.TokenStatus;
import net.jeremybrooks.knicker.dto.Word;
import net.jeremybrooks.knicker.dto.WordFrequency;
import net.jeremybrooks.knicker.dto.WordList;
import net.jeremybrooks.knicker.dto.WordListWord;
import net.jeremybrooks.knicker.dto.WordOfTheDay;
import net.jeremybrooks.knicker.logger.KnickerLogger;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Knicker {
    private static final String WORD_ENDPOINT = "http://api.wordnik.com/api/word.xml";
    private static final String WORDS_ENDPOINT = "http://api.wordnik.com/api/words.xml";
    private static final String SUGGEST_ENDPOINT = "http://api.wordnik.com/api/suggest.xml";
    private static final String WOTD_ENDPOINT = "http://api.wordnik.com/api/wordoftheday.xml";
    private static final String ACCOUNT_ENDPOINT = "https://api.wordnik.com/api/account.xml";
    private static final String WORDLIST_ENDPOINT = "https://api.wordnik.com/api/wordList.xml";
    private static final String WORDLISTS_ENDPOINT = "https://api.wordnik.com/api/wordLists.xml";

    public static Word lookup(String word) throws KnickerException {
        return Knicker.lookup(word, false, false);
    }

    public static Word lookup(String word, boolean useSuggest, boolean literal) throws KnickerException {
        if (word == null || word.isEmpty()) {
            throw new KnickerException("Cannot look up an empty word.");
        }
        StringBuilder uri = new StringBuilder(WORD_ENDPOINT);
        uri.append('/').append(word.trim());
        if (useSuggest) {
            uri.append("?").append("useSuggest=true");
            if (literal) {
                uri.append("&").append("literal=true");
            }
        }
        Document doc = Util.doGet(uri.toString());
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(doc);
            transformer.transform(source, result);
            String xmlString = result.getWriter().toString();
            KnickerLogger.getLogger().log(xmlString);
        }
        catch (Exception e) {
            throw new KnickerException("", e);
        }
        return DTOBuilder.buildWord(doc);
    }

    public static List<Phrase> phrase(String word) throws KnickerException {
        return Knicker.phrase(word, 0);
    }

    public static List<Phrase> phrase(String word, int limit) throws KnickerException {
        if (word == null || word.isEmpty()) {
            throw new KnickerException("Cannot look up an empty word.");
        }
        StringBuilder uri = new StringBuilder(WORD_ENDPOINT);
        uri.append('/').append(word.trim());
        uri.append("/phrases");
        if (limit > 0) {
            uri.append("?limit=").append(limit);
        }
        Document doc = Util.doGet(uri.toString());
        return DTOBuilder.buildPhrase(doc);
    }

    public static List<Definition> definitions(String word) throws KnickerException {
        return Knicker.definitions(word, 0, false, null, null);
    }

    public static List<Definition> definitions(String word, SourceDictionary sourceDictionary) throws KnickerException {
        return Knicker.definitions(word, 0, false, sourceDictionary, null);
    }

    public static List<Definition> definitions(String word, int limit, boolean useCanonical, SourceDictionary sourceDictionary, EnumSet<PartOfSpeech> partOfSpeech) throws KnickerException {
        if (word == null || word.isEmpty()) {
            throw new KnickerException("Cannot look up an empty word.");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        if (limit > 0) {
            params.put("limit", Integer.toString(limit));
        }
        if (useCanonical) {
            params.put("useCanonical", "true");
        }
        if (sourceDictionary != null) {
            params.put("sourceDictionary", sourceDictionary.toString());
        }
        if (partOfSpeech != null && partOfSpeech.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (PartOfSpeech pos : partOfSpeech) {
                sb.append(pos.toString().trim().replaceAll("_", "-")).append(',');
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            params.put("partOfSpeech", sb.toString());
        }
        StringBuilder uri = new StringBuilder(WORD_ENDPOINT);
        uri.append('/').append(word.trim());
        uri.append("/definitions");
        if (params.size() > 0) {
            uri.append('?').append(Util.buildParamList(params));
        }
        return DTOBuilder.buildDefinitions(Util.doGet(uri.toString()));
    }

    public static List<Example> examples(String word) throws KnickerException {
        return Knicker.examples(word, false);
    }

    public static List<Example> examples(String word, boolean useCanonical) throws KnickerException {
        if (word == null || word.isEmpty()) {
            throw new KnickerException("Cannot look up an empty word.");
        }
        StringBuilder uri = new StringBuilder(WORD_ENDPOINT);
        uri.append('/').append(word.trim());
        uri.append("/examples");
        if (useCanonical) {
            uri.append("?useCanonical=true");
        }
        return DTOBuilder.buildExamples(Util.doGet(uri.toString()));
    }

    public static List<Related> related(String word) throws KnickerException {
        return Knicker.related(word, 0, false, null, null, null);
    }

    public static List<Related> related(String word, SourceDictionary sourceDictionary) throws KnickerException {
        return Knicker.related(word, 0, false, null, null, sourceDictionary);
    }

    public static List<Related> related(String word, int limit, boolean useCanonical, EnumSet<PartOfSpeech> partOfSpeech, List<RelationshipType> relationshipType, SourceDictionary sourceDictionary) throws KnickerException {
        StringBuilder sb;
        if (word == null || word.isEmpty()) {
            throw new KnickerException("Cannot look up an empty word.");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        if (limit > 0) {
            params.put("limit", Integer.toString(limit));
        }
        if (useCanonical) {
            params.put("useCanonical", "true");
        }
        if (sourceDictionary != null) {
            params.put("sourceDictionary", sourceDictionary.toString());
        }
        if (partOfSpeech != null && partOfSpeech.size() > 0) {
            sb = new StringBuilder();
            for (PartOfSpeech pos : partOfSpeech) {
                sb.append(pos.toString().trim().replaceAll("_", "-")).append(',');
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            params.put("partOfSpeech", sb.toString());
        }
        if (relationshipType != null && relationshipType.size() > 0) {
            sb = new StringBuilder();
            for (RelationshipType rt : relationshipType) {
                sb.append(rt.toString().trim().replaceAll("_", "-")).append(',');
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            params.put("relationshipType", sb.toString());
        }
        StringBuilder uri = new StringBuilder(WORD_ENDPOINT);
        uri.append('/').append(word.trim());
        uri.append("/related");
        uri.append('?').append(Util.buildParamList(params));
        return DTOBuilder.buildRelated(Util.doGet(uri.toString()));
    }

    public static FrequencySummary frequency(String word) throws KnickerException {
        return Knicker.frequency(word, false);
    }

    public static FrequencySummary frequency(String word, boolean useCanonical) throws KnickerException {
        if (word == null || word.isEmpty()) {
            throw new KnickerException("Cannot look up an empty word.");
        }
        StringBuilder uri = new StringBuilder(WORD_ENDPOINT);
        uri.append('/').append(word.trim());
        uri.append("/frequency");
        if (useCanonical) {
            uri.append("?useCanonical=true");
        }
        return DTOBuilder.buildFrequencySummary(Util.doGet(uri.toString()));
    }

    public static PunctuationFactor punctuationFactor(String word) throws KnickerException {
        return Knicker.punctuationFactor(word, false);
    }

    public static PunctuationFactor punctuationFactor(String word, boolean useCanonical) throws KnickerException {
        if (word == null || word.isEmpty()) {
            throw new KnickerException("Cannot look up an empty word.");
        }
        StringBuilder uri = new StringBuilder(WORD_ENDPOINT);
        uri.append('/').append(word.trim());
        uri.append("/punctuationFactor");
        if (useCanonical) {
            uri.append("?useCanonical=true");
        }
        return DTOBuilder.buildPunctuationFactor(Util.doGet(uri.toString()));
    }

    public static List<Pronunciation> pronunciations(String word) throws KnickerException {
        return Knicker.pronunciations(word, false);
    }

    public static List<Pronunciation> pronunciations(String word, boolean useCanonical) throws KnickerException {
        if (word == null || word.isEmpty()) {
            throw new KnickerException("Cannot look up an empty word.");
        }
        StringBuilder uri = new StringBuilder(WORD_ENDPOINT);
        uri.append('/').append(word.trim());
        uri.append("/pronunciations");
        if (useCanonical) {
            uri.append("?useCanonical=true");
        }
        return DTOBuilder.buildPronunciation(Util.doGet(uri.toString()));
    }

    public static SearchResult autocomplete(String wordFragment) throws KnickerException {
        return Knicker.autocomplete(wordFragment, 0, 0, false, false);
    }

    public static SearchResult autocomplete(String wordFragment, int limit, int skip, boolean sortAlpha, boolean hasDef) throws KnickerException {
        if (wordFragment == null || wordFragment.isEmpty()) {
            throw new KnickerException("Cannot look up an empty word fragment.");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        if (limit > 0) {
            params.put("limit", Integer.toString(limit));
        }
        if (skip > 0) {
            params.put("skip", Integer.toString(skip));
        }
        if (sortAlpha) {
            params.put("sortBy", "alpha");
        }
        if (hasDef) {
            params.put("hasDictionaryDef", "true");
        }
        StringBuilder uri = new StringBuilder(SUGGEST_ENDPOINT);
        uri.append('/').append(wordFragment.trim());
        if (params.size() > 0) {
            uri.append('?').append(Util.buildParamList(params));
        }
        return DTOBuilder.buildSearchResult(Util.doGet(uri.toString()));
    }

    public static WordOfTheDay wordOfTheDay() throws KnickerException {
        return DTOBuilder.buildWordOfTheDay(Util.doGet(WOTD_ENDPOINT));
    }

    public static Word randomWord(boolean hasDictionaryDef) throws KnickerException {
        StringBuilder uri = new StringBuilder(WORDS_ENDPOINT);
        uri.append("/randomWord");
        if (hasDictionaryDef) {
            uri.append("?hasDictionaryDef=true");
        }
        return DTOBuilder.buildWord(Util.doGet(uri.toString()));
    }

    public static List<Word> randomWords() throws KnickerException {
        return Knicker.randomWords(null, null, 0, 0, 0, 0, 0, 0, 0, 0);
    }

    public static List<Word> randomWords(EnumSet<PartOfSpeech> includePartOfSpeech, EnumSet<PartOfSpeech> excludePartOfSpeech, int minCorpusCount, int maxCorpusCount, int minDictionaryCount, int maxDictionaryCount, int minLength, int maxLength, int skip, int limit) throws KnickerException {
        StringBuilder sb;
        HashMap<String, String> params = new HashMap<String, String>();
        if (includePartOfSpeech != null && !includePartOfSpeech.isEmpty()) {
            sb = new StringBuilder();
            for (PartOfSpeech pos : includePartOfSpeech) {
                sb.append((Object)pos).append(',');
            }
            sb.deleteCharAt(sb.lastIndexOf(","));
            params.put("includePartOfSpeech", sb.toString());
        }
        if (excludePartOfSpeech != null && !excludePartOfSpeech.isEmpty()) {
            sb = new StringBuilder();
            for (PartOfSpeech pos : excludePartOfSpeech) {
                sb.append((Object)pos).append(',');
            }
            sb.deleteCharAt(sb.lastIndexOf(","));
            params.put("excludePartOfSpeech", sb.toString());
        }
        if (minCorpusCount > 0) {
            params.put("minCorpusCount", Integer.toString(minCorpusCount));
        }
        if (maxCorpusCount > 0) {
            params.put("maxCorpusCount", Integer.toString(maxCorpusCount));
        }
        if (minDictionaryCount > 0) {
            params.put("minDictionaryCount", Integer.toString(minDictionaryCount));
        }
        if (maxDictionaryCount > 0) {
            params.put("maxDictionaryCount", Integer.toString(maxDictionaryCount));
        }
        if (minLength > 0) {
            params.put("minLength", Integer.toString(minLength));
        }
        if (maxLength > 0) {
            params.put("maxLength", Integer.toString(maxLength));
        }
        if (skip > 0) {
            params.put("skip", Integer.toString(skip));
        }
        if (limit > 0) {
            params.put("limit", Integer.toString(limit));
        }
        StringBuilder uri = new StringBuilder(WORDS_ENDPOINT);
        uri.append("/randomWords");
        if (params.size() > 0) {
            uri.append('?').append(Util.buildParamList(params));
        }
        return DTOBuilder.buildWords(Util.doGet(uri.toString()));
    }

    public static AuthenticationToken authenticate(String username, String password) throws KnickerException {
        if (username == null || username.isEmpty()) {
            throw new KnickerException("You must specify a username.");
        }
        if (password == null || password.isEmpty()) {
            throw new KnickerException("You must specify a password.");
        }
        AuthenticationToken auth = null;
        StringBuilder uri = new StringBuilder(ACCOUNT_ENDPOINT);
        uri.append("/authenticate/").append(username);
        uri.append("?password=").append(password);
        try {
            auth = DTOBuilder.buildAuthenticationToken(Util.doGet(uri.toString()));
        }
        catch (Exception e) {
            throw new KnickerException("Unable to authenticate. Check your username and password.", e);
        }
        return auth;
    }

    public static TokenStatus status() throws KnickerException {
        StringBuilder uri = new StringBuilder(ACCOUNT_ENDPOINT);
        uri.append("/apiTokenStatus");
        return DTOBuilder.buildTokenStatus(Util.doGet(uri.toString()));
    }

    public static List<WordList> getLists(AuthenticationToken token) throws KnickerException {
        if (token == null) {
            throw new KnickerException("Authentication token required.");
        }
        StringBuilder uri = new StringBuilder(WORDLISTS_ENDPOINT);
        return DTOBuilder.buildWordLists(Util.doGet(uri.toString(), token));
    }

    public static WordList createList(AuthenticationToken token, String listName, String description, ListType type) throws KnickerException {
        if (token == null) {
            throw new KnickerException("Authentication token required.");
        }
        if (listName == null || listName.isEmpty()) {
            throw new KnickerException("List name required.");
        }
        if (description == null || description.isEmpty()) {
            throw new KnickerException("Description required.");
        }
        if (type == null) {
            throw new KnickerException("List type required.");
        }
        StringBuilder data = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n");
        data.append("<wordList>\n");
        data.append("<description>").append(description).append("</description>\n");
        data.append("<name>").append(listName).append("</name>\n");
        data.append("<type>").append(type.toString()).append("</type>\n");
        data.append("</wordList>");
        return DTOBuilder.buildWordList(Util.doPost(WORDLISTS_ENDPOINT, data.toString(), token));
    }

    public static void addWordToList(AuthenticationToken token, String permalinkId, String word) throws KnickerException {
        if (token == null) {
            throw new KnickerException("Authentication token required.");
        }
        if (permalinkId == null || permalinkId.isEmpty()) {
            throw new KnickerException("Parameter permalinkId required.");
        }
        if (word == null || word.isEmpty()) {
            throw new KnickerException("Parameter word required.");
        }
        StringBuilder data = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n");
        data.append("<stringValues>\n");
        data.append("<stringValue>\n");
        data.append("<wordstring>").append(word).append("</wordstring>\n");
        data.append("</stringValue>\n");
        data.append("</stringValues>\n");
        StringBuilder uri = new StringBuilder(WORDLIST_ENDPOINT);
        uri.append("/").append(permalinkId).append("/words");
        Util.doPost(uri.toString(), data.toString(), token);
    }

    public static List<WordListWord> getWordsFromList(AuthenticationToken token, String permalinkId) throws KnickerException {
        if (token == null) {
            throw new KnickerException("Authentication token required.");
        }
        if (permalinkId == null || permalinkId.isEmpty()) {
            throw new KnickerException("Parameter permalinkId required.");
        }
        StringBuilder uri = new StringBuilder(WORDLIST_ENDPOINT);
        uri.append("/").append(permalinkId).append("/words");
        return DTOBuilder.buildWordListWords(Util.doGet(uri.toString(), token));
    }

    public static void deleteWordFromList(AuthenticationToken token, String permalinkId, String word) throws KnickerException {
        if (token == null) {
            throw new KnickerException("Authentication token required.");
        }
        if (permalinkId == null || permalinkId.isEmpty()) {
            throw new KnickerException("Parameter permalinkId required.");
        }
        if (word == null || word.isEmpty()) {
            throw new KnickerException("Parameter word required.");
        }
        StringBuilder data = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n");
        data.append("<stringValues>\n");
        data.append("<stringValue>\n");
        data.append("<wordstring>").append(word).append("</wordstring>\n");
        data.append("</stringValue>\n");
        data.append("</stringValues>\n");
        StringBuilder uri = new StringBuilder(WORDLIST_ENDPOINT);
        uri.append("/").append(permalinkId).append("/deleteWords");
        Util.doPost(uri.toString(), data.toString(), token);
    }

    public static void deleteList(AuthenticationToken token, String permalinkId) throws KnickerException {
        if (token == null) {
            throw new KnickerException("Authentication token required.");
        }
        if (permalinkId == null || permalinkId.isEmpty()) {
            throw new KnickerException("Parameter permalinkId required.");
        }
        StringBuilder uri = new StringBuilder(WORDLIST_ENDPOINT);
        uri.append("/").append(permalinkId);
        Util.doDelete(uri.toString(), null, token);
    }

    public static List<WordFrequency> wordSearch(String query) throws KnickerException {
        return Knicker.wordSearch(query, null, null, 0, 0, 0, 0, 0, 0, 0, 0);
    }

    public static List<WordFrequency> wordSearch(String query, EnumSet<PartOfSpeech> includePartOfSpeech, EnumSet<PartOfSpeech> excludePartOfSpeech, int minCorpusCount, int maxCorpusCount, int minDictionaryCount, int maxDictionaryCount, int minLength, int maxLength, int skip, int limit) throws KnickerException {
        StringBuilder sb;
        if (query == null || query.isEmpty()) {
            throw new KnickerException("You must provide a search query.");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("query", query);
        if (includePartOfSpeech != null && !includePartOfSpeech.isEmpty()) {
            sb = new StringBuilder();
            for (PartOfSpeech pos : includePartOfSpeech) {
                sb.append((Object)pos).append(',');
            }
            sb.deleteCharAt(sb.lastIndexOf(","));
            params.put("includePartOfSpeech", sb.toString());
        }
        if (excludePartOfSpeech != null && !excludePartOfSpeech.isEmpty()) {
            sb = new StringBuilder();
            for (PartOfSpeech pos : excludePartOfSpeech) {
                sb.append((Object)pos).append(',');
            }
            sb.deleteCharAt(sb.lastIndexOf(","));
            params.put("excludePartOfSpeech", sb.toString());
        }
        if (minCorpusCount > 0) {
            params.put("minCorpusCount", Integer.toString(minCorpusCount));
        }
        if (maxCorpusCount > 0) {
            params.put("maxCorpusCount", Integer.toString(maxCorpusCount));
        }
        if (minDictionaryCount > 0) {
            params.put("minDictionaryCount", Integer.toString(minDictionaryCount));
        }
        if (maxDictionaryCount > 0) {
            params.put("maxDictionaryCount", Integer.toString(maxDictionaryCount));
        }
        if (minLength > 0) {
            params.put("minLength", Integer.toString(minLength));
        }
        if (maxLength > 0) {
            params.put("maxLength", Integer.toString(maxLength));
        }
        if (skip > 0) {
            params.put("skip", Integer.toString(skip));
        }
        if (limit > 0) {
            params.put("limit", Integer.toString(limit));
        }
        StringBuilder uri = new StringBuilder(WORDS_ENDPOINT);
        uri.append("/search");
        if (params.size() > 0) {
            uri.append('?').append(Util.buildParamList(params));
        }
        return DTOBuilder.buildWordFrequency(Util.doGet(uri.toString()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ListType {
        PUBLIC,
        PRIVATE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RelationshipType {
        synonym,
        antonym,
        form,
        hyponym,
        variant,
        verb_stem,
        verb_form,
        cross_reference,
        same_context;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PartOfSpeech {
        noun,
        verb,
        adjective,
        adverb,
        idiom,
        article,
        abbreviation,
        preposition,
        prefix,
        interjection,
        suffix,
        conjunction,
        adjective_and_adverb,
        noun_and_adjective,
        noun_and_verb_transitive,
        noun_and_verb,
        past_participle,
        imperative,
        noun_plural,
        proper_noun_plural,
        verb_intransitive,
        proper_noun,
        adjective_and_noun,
        imperative_and_past_participle,
        pronoun,
        verb_transitive,
        noun_and_verb_intransitive,
        adverb_and_preposition,
        proper_noun_posessive,
        noun_posessive;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SourceDictionary {
        ahd,
        century,
        wiktionary,
        webster,
        wordnet;

    }
}

