/*
 * Decompiled with CFR 0.152.
 */
package net.jeremybrooks.knicker;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathFactory;
import net.jeremybrooks.knicker.KnickerException;
import net.jeremybrooks.knicker.dto.AuthenticationToken;
import net.jeremybrooks.knicker.logger.KnickerLogger;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private static XPathFactory xPathFactory = XPathFactory.newInstance();

    static Document doGet(String uri) throws KnickerException {
        return Util.doGet(uri, null);
    }

    static Document doGet(String uri, AuthenticationToken token) throws KnickerException {
        if (uri == null || uri.trim().isEmpty()) {
            throw new KnickerException("Parameter uri cannot be null or empty.");
        }
        if (!uri.startsWith("http://") && !uri.startsWith("https://")) {
            throw new KnickerException("Parameter uri must start with http:// or https://");
        }
        KnickerLogger.getLogger().log("GET URL: '" + uri + "'");
        BufferedReader rd = null;
        String result = null;
        try {
            String line;
            URL url = new URL(uri);
            URLConnection conn = url.openConnection();
            conn.setConnectTimeout(Util.getConnTimeout());
            conn.setReadTimeout(Util.getReadTimeout());
            conn.addRequestProperty("api_key", System.getProperty("WORDNIK_API_KEY"));
            if (token != null) {
                conn.addRequestProperty("auth_token", token.getToken());
            }
            rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder sb = new StringBuilder();
            KnickerLogger.getLogger().log("----------RESPONSE START----------");
            while ((line = rd.readLine()) != null) {
                sb.append(line);
                KnickerLogger.getLogger().log(line);
            }
            KnickerLogger.getLogger().log("----------RESPONSE END----------");
            rd.close();
            result = sb.toString();
        }
        catch (Exception e) {
            throw new KnickerException("Error getting a response from the server.", e);
        }
        finally {
            if (rd != null) {
                try {
                    rd.close();
                }
                catch (Exception e) {}
            }
        }
        return Util.getDocument(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static Document doPost(String uri, String data, AuthenticationToken token) throws KnickerException {
        if (uri == null || uri.trim().isEmpty()) {
            throw new KnickerException("Parameter uri cannot be null or empty.");
        }
        if (!uri.startsWith("http://") && !uri.startsWith("https://")) {
            throw new KnickerException("Parameter uri must start with http:// or https://");
        }
        FilterOutputStream out = null;
        BufferedReader in = null;
        StringBuilder sb = new StringBuilder();
        KnickerLogger.getLogger().log("POST URL: '" + uri + "'");
        try {
            String line;
            URL url = new URL(uri);
            URLConnection conn = url.openConnection();
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setUseCaches(false);
            conn.setConnectTimeout(Util.getConnTimeout());
            conn.setReadTimeout(Util.getReadTimeout());
            ((HttpURLConnection)conn).setRequestMethod("POST");
            conn.addRequestProperty("api_key", System.getProperty("WORDNIK_API_KEY"));
            KnickerLogger.getLogger().log("added header 'api_key', " + System.getProperty("WORDNIK_API_KEY"));
            if (token != null) {
                conn.addRequestProperty("auth_token", token.getToken());
                KnickerLogger.getLogger().log("added header 'auth_token', " + token.getToken());
            }
            conn.addRequestProperty("Content-Type", "text/xml");
            out = new DataOutputStream(conn.getOutputStream());
            KnickerLogger.getLogger().log("----------POST DATA START----------");
            KnickerLogger.getLogger().log(data);
            KnickerLogger.getLogger().log("----------POST DATA END----------");
            ((DataOutputStream)out).writeBytes(data);
            ((DataOutputStream)out).flush();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            KnickerLogger.getLogger().log("----------RESPONSE START----------");
            while ((line = in.readLine()) != null) {
                sb.append(line);
                KnickerLogger.getLogger().log(line);
            }
            KnickerLogger.getLogger().log("----------RESPONSE END----------");
        }
        catch (Exception e) {
            throw new KnickerException("Error while performing HTTP POST operation.", e);
        }
        finally {
            block34: {
                block33: {
                    if (out == null) break block33;
                    out.close();
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                    break block34;
                }
                catch (Exception e) {}
                break block34;
                catch (Exception e) {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception e2) {}
                    catch (Throwable throwable) {
                        try {
                            if (in != null) {
                                in.close();
                            }
                        }
                        catch (Exception e3) {}
                        throw throwable;
                    }
                }
            }
        }
        return Util.getDocument(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static void doDelete(String uri, String data, AuthenticationToken token) throws KnickerException {
        if (uri == null || uri.trim().isEmpty()) {
            throw new KnickerException("Parameter uri cannot be null or empty.");
        }
        if (!uri.startsWith("http://") && !uri.startsWith("https://")) {
            throw new KnickerException("Parameter uri must start with http:// or https://");
        }
        FilterOutputStream out = null;
        BufferedReader in = null;
        StringBuilder sb = new StringBuilder();
        KnickerLogger.getLogger().log("DELETE URL: '" + uri + "'");
        try {
            URL url = new URL(uri);
            URLConnection conn = url.openConnection();
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setUseCaches(false);
            conn.setConnectTimeout(Util.getConnTimeout());
            conn.setReadTimeout(Util.getReadTimeout());
            ((HttpURLConnection)conn).setRequestMethod("DELETE");
            conn.addRequestProperty("api_key", System.getProperty("WORDNIK_API_KEY"));
            KnickerLogger.getLogger().log("added header 'api_key', " + System.getProperty("WORDNIK_API_KEY"));
            if (token != null) {
                conn.addRequestProperty("auth_token", token.getToken());
                KnickerLogger.getLogger().log("added header 'auth_token', " + token.getToken());
            }
            conn.addRequestProperty("Content-Type", "text/xml");
            out = new DataOutputStream(conn.getOutputStream());
            KnickerLogger.getLogger().log("----------DELETE DATA START----------");
            if (data != null) {
                KnickerLogger.getLogger().log(data);
                ((DataOutputStream)out).writeBytes(data);
                ((DataOutputStream)out).flush();
            }
            KnickerLogger.getLogger().log("----------DELETE DATA END----------");
            in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        }
        catch (Exception e) {
            throw new KnickerException("Error while performing HTTP DELETE operation.", e);
        }
        finally {
            block34: {
                block33: {
                    if (out == null) break block33;
                    out.close();
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                    break block34;
                }
                catch (Exception e) {}
                break block34;
                catch (Exception e) {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception e2) {}
                    catch (Throwable throwable) {
                        try {
                            if (in != null) {
                                in.close();
                            }
                        }
                        catch (Exception e3) {}
                        throw throwable;
                    }
                }
            }
        }
    }

    private static Document getDocument(String xml) throws KnickerException {
        Document retDoc = null;
        ByteArrayInputStream in = null;
        if (xml != null && xml.trim().length() > 0) {
            try {
                in = new ByteArrayInputStream(xml.getBytes("UTF-8"));
                retDoc = documentBuilderFactory.newDocumentBuilder().parse(in);
            }
            catch (Exception e) {
                throw new KnickerException("Unable to create Document.", e);
            }
            finally {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        return retDoc;
    }

    static String getValueByXPath(Document document, String xpath) {
        String value = "";
        try {
            value = xPathFactory.newXPath().evaluate(xpath, document).trim();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    static int getValueByXPathAsInt(Document document, String xpath) {
        int x = 0;
        try {
            x = Integer.parseInt(Util.getValueByXPath(document, xpath));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return x;
    }

    static long getValueByXPathAsLong(Document document, String xpath) {
        long x = 0L;
        try {
            x = Long.parseLong(Util.getValueByXPath(document, xpath));
        }
        catch (Exception e) {
            // empty catch block
        }
        return x;
    }

    static boolean getValueByXPathAsBoolean(Document document, String xpath) {
        boolean b = false;
        try {
            b = Util.getValueByXPath(document, xpath).equals("true");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return b;
    }

    static int getNamedChildTextContentAsInt(Node node, String name) {
        int value = 0;
        try {
            value = Integer.parseInt(Util.getNamedChildTextContent(node, name));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    static String getNamedChildTextContent(Node node, String name) {
        String content;
        block4: {
            content = "";
            if (node != null) {
                try {
                    NodeList nodes = node.getChildNodes();
                    if (nodes == null) break block4;
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Node child = nodes.item(i);
                        if (!child.getNodeName().equals(name)) continue;
                        content = child.getTextContent();
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return content.trim();
    }

    static Node getNamedChildNode(Node node, String name) {
        if (node == null || name == null || name.trim().isEmpty()) {
            return null;
        }
        Node retNode = null;
        NodeList nodes = node.getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node n = nodes.item(i);
                if (!n.getNodeName().equals(name)) continue;
                retNode = n;
                break;
            }
        }
        return retNode;
    }

    static String buildParamList(Map<String, String> params) throws KnickerException {
        StringBuilder sb = new StringBuilder();
        for (String key : params.keySet()) {
            try {
                sb.append(URLEncoder.encode(key, "UTF-8")).append('=').append(URLEncoder.encode(params.get(key), "UTF-8")).append('&');
            }
            catch (Exception e) {
                throw new KnickerException("Error encoding.", e);
            }
        }
        int index = sb.lastIndexOf("&");
        if (index > 0) {
            sb.deleteCharAt(sb.lastIndexOf("&"));
        }
        return sb.toString();
    }

    static String getAttribute(NamedNodeMap map, String name) {
        String value = "";
        try {
            Node node = map.getNamedItem(name);
            if (node != null) {
                value = node.getNodeValue().trim();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    static int getAttributeAsInt(NamedNodeMap map, String name) {
        int value = 0;
        try {
            value = Integer.parseInt(Util.getAttribute(map, name));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    static boolean getAttributeAsBoolean(NamedNodeMap map, String name) {
        boolean value = false;
        try {
            value = Util.getAttribute(map, name).equals("1");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    protected static int getConnTimeout() {
        int timeout = 10000;
        try {
            timeout = Integer.parseInt("KNICKER_CONN_TIMEOUT");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return timeout;
    }

    protected static int getReadTimeout() {
        int timeout = 30000;
        try {
            timeout = Integer.parseInt("KNICKER_READ_TIMEOUT");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return timeout;
    }
}

