/*
 * Decompiled with CFR 0.152.
 */
package net.jeremybrooks.knicker.dto;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Definition {
    private int sequence;
    private String id;
    private List<Citation> citations;
    private String text;
    private String headword;
    private List<Label> labels = new ArrayList<Label>();
    private List<Note> notes;
    private String partOfSpeech;
    private String seqString;
    private List<String> exampleUses;

    public Definition() {
        this.citations = new ArrayList<Citation>();
        this.notes = new ArrayList<Note>();
        this.exampleUses = new ArrayList<String>();
    }

    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int sequence) {
        this.sequence = sequence;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<Citation> getCitations() {
        return this.citations;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getHeadword() {
        return this.headword;
    }

    public void setHeadword(String headword) {
        this.headword = headword;
    }

    public List<Label> getLabels() {
        return this.labels;
    }

    public List<Note> getNotes() {
        return this.notes;
    }

    public String getPartOfSpeech() {
        return this.partOfSpeech;
    }

    public void setPartOfSpeech(String partOfSpeech) {
        this.partOfSpeech = partOfSpeech;
    }

    public String getSeqString() {
        return this.seqString;
    }

    public void setSeqString(String seqString) {
        this.seqString = seqString;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append(": [ sequence=").append(this.sequence).append(" | ");
        sb.append("id=").append(this.id).append(" | ");
        sb.append("text=").append(this.text).append(" | ");
        sb.append("headword=").append(this.headword).append(" | ");
        sb.append("partOfSpeech=").append(this.partOfSpeech).append(" | ");
        sb.append("seqString=").append(this.seqString).append(" | ");
        sb.append("citations=");
        if (this.citations != null) {
            for (Citation c : this.citations) {
                sb.append('<').append(c.toString()).append('>');
            }
        }
        sb.append(" | ").append("labels=");
        if (this.labels != null) {
            for (Label l : this.labels) {
                sb.append('<').append(l.toString()).append('>');
            }
        }
        sb.append(" | ").append("notes=");
        if (this.notes != null) {
            for (Note n : this.notes) {
                sb.append('<').append(n.toString()).append('>');
            }
        }
        sb.append(" | ").append("exampleUses=");
        if (this.exampleUses != null) {
            for (String s : this.exampleUses) {
                sb.append('<').append(s).append('>');
            }
        }
        sb.append(" ]");
        return sb.toString();
    }

    public void addCitation(String cite, String source) {
        Citation citation = new Citation();
        citation.setCite(cite);
        citation.setSource(source);
        this.citations.add(citation);
    }

    public void addLabel(String type, String text) {
        Label label = new Label();
        label.setText(text);
        label.setType(type);
        this.labels.add(label);
    }

    public void addNote(int pos, String value) {
        Note note = new Note();
        note.setPos(pos);
        note.setValue(value);
        this.notes.add(note);
    }

    public void addExampleUse(String exampleUse) {
        this.exampleUses.add(exampleUse);
    }

    public List<String> getExampleUses() {
        return this.exampleUses;
    }

    public class Note {
        private int pos;
        private String value;

        public int getPos() {
            return this.pos;
        }

        public void setPos(int pos) {
            this.pos = pos;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getName());
            sb.append(": [ pos=").append(this.pos).append(" | ");
            sb.append("value=").append(this.value).append(" ]");
            return sb.toString();
        }
    }

    public class Label {
        private String type;
        private String text;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getName());
            sb.append(": [ type=").append(this.type).append(" | ");
            sb.append("text=").append(this.text).append(" ]");
            return sb.toString();
        }
    }

    public class Citation {
        private String cite;
        private String source;

        public String getCite() {
            return this.cite;
        }

        public void setCite(String cite) {
            this.cite = cite;
        }

        public String getSource() {
            return this.source;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getName());
            sb.append(": [ cite=").append(this.cite).append(" | ");
            sb.append("source=").append(this.source).append(" ]");
            return sb.toString();
        }
    }
}

