/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.ant;

import com.izforge.izpack.ant.ConfigHolder;
import com.izforge.izpack.ant.Property;
import com.izforge.izpack.compiler.CompilerConfig;
import com.izforge.izpack.compiler.CompilerException;
import com.izforge.izpack.compiler.PackagerListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.PropertySet;

public class IzPackTask
extends Task
implements PackagerListener {
    private ConfigHolder config = null;
    private String input = null;
    private String basedir = null;
    private String output = null;
    private String compression = "default";
    private int compressionLevel = -1;
    private InstallerType installerType = null;
    private String izPackDir = null;
    private Properties properties;
    private boolean inheritAll = false;

    public ConfigHolder createConfig() {
        this.config = new ConfigHolder(this.getProject());
        return this.config;
    }

    public void packagerMsg(String str) {
        this.packagerMsg(str, 2);
    }

    public void packagerMsg(String str, int priority) {
        int antPriority;
        switch (priority) {
            case 0: {
                antPriority = 4;
                break;
            }
            case 1: {
                antPriority = 0;
                break;
            }
            case 2: {
                antPriority = 2;
                break;
            }
            case 3: {
                antPriority = 3;
                break;
            }
            case 4: {
                antPriority = 1;
                break;
            }
            default: {
                antPriority = 2;
            }
        }
        this.log(str, antPriority);
    }

    public void packagerStart() {
        this.log(ResourceBundle.getBundle("com/izforge/izpack/ant/langpacks/messages").getString("Packager_starting"), 4);
    }

    public void packagerStop() {
        this.log(ResourceBundle.getBundle("com/izforge/izpack/ant/langpacks/messages").getString("Packager_ended"), 4);
    }

    public void execute() throws BuildException {
        if (this.input == null && this.config == null) {
            throw new BuildException(ResourceBundle.getBundle("com/izforge/izpack/ant/langpacks/messages").getString("input_must_be_specified"));
        }
        if (this.output == null) {
            throw new BuildException(ResourceBundle.getBundle("com/izforge/izpack/ant/langpacks/messages").getString("output_must_be_specified"));
        }
        if (this.basedir == null) {
            throw new BuildException(ResourceBundle.getBundle("com/izforge/izpack/ant/langpacks/messages").getString("basedir_must_be_specified"));
        }
        String kind = this.installerType == null ? null : this.installerType.getValue();
        CompilerConfig c = null;
        String configText = null;
        if (this.config != null) {
            configText = this.config.getText();
            this.input = null;
        }
        try {
            c = new CompilerConfig(this.input, this.basedir, kind, this.output, this.compression, this.compressionLevel, this, configText);
        }
        catch (CompilerException e1) {
            throw new BuildException(e1);
        }
        CompilerConfig.setIzpackHome(this.izPackDir);
        if (this.properties != null) {
            Enumeration<Object> e = this.properties.keys();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String value = this.properties.getProperty(name);
                c.addProperty(name, value);
            }
        }
        if (this.inheritAll) {
            Hashtable projectProps = this.getProject().getProperties();
            Enumeration e = projectProps.keys();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String value = (String)projectProps.get(name);
                c.addProperty(name, value);
            }
        }
        try {
            c.executeCompiler();
        }
        catch (Exception e) {
            throw new BuildException(e);
        }
    }

    public void setInput(String input) {
        this.input = input;
    }

    public void setBasedir(String basedir) {
        this.basedir = basedir;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public void setInstallerType(InstallerType installerType) {
        this.installerType = installerType;
    }

    public void setIzPackDir(String izPackDir) {
        if (!izPackDir.endsWith("/")) {
            izPackDir = izPackDir + "/";
        }
        this.izPackDir = izPackDir;
    }

    public void setInheritAll(boolean value) {
        this.inheritAll = value;
    }

    public void setCompression(String compression) {
        this.compression = compression;
    }

    public void setCompressionLevel(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    public void addConfiguredProperty(Property property) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        property.execute();
        Properties props = property.getProperties();
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = props.getProperty(name);
            this.log("Adding property: " + property.getClass() + name + "=" + value, 3);
            this.properties.setProperty(name, value);
        }
    }

    public void addConfiguredPropertyset(PropertySet ps) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.putAll((Map<?, ?>)ps.getProperties());
    }

    public static class InstallerType
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"standard", "web"};
        }
    }
}

