/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.compiler;

import com.izforge.izpack.compiler.Compiler;
import com.izforge.izpack.compiler.CompilerConfig;
import com.izforge.izpack.compiler.CompilerException;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import net.n3.nanoxml.XMLElement;
import org.apache.tools.ant.taskdefs.Execute;

public class Property {
    protected String name;
    protected String value;
    protected File file;
    protected String env;
    protected String prefix;
    protected XMLElement xmlProp;
    protected CompilerConfig config;
    protected Compiler compiler;

    public Property(XMLElement xmlProp, CompilerConfig config) {
        String filename;
        this.xmlProp = xmlProp;
        this.config = config;
        this.compiler = config.getCompiler();
        this.name = xmlProp.getAttribute("name");
        this.value = xmlProp.getAttribute("value");
        this.env = xmlProp.getAttribute("environment");
        if (this.env != null && !this.env.endsWith(".")) {
            this.env = this.env + ".";
        }
        this.prefix = xmlProp.getAttribute("prefix");
        if (this.prefix != null && !this.prefix.endsWith(".")) {
            this.prefix = this.prefix + ".";
        }
        if ((filename = xmlProp.getAttribute("file")) != null) {
            this.file = new File(filename);
        }
    }

    public String getValue() {
        return this.toString();
    }

    public String toString() {
        return this.value == null ? "" : this.value;
    }

    public void execute() throws CompilerException {
        if (this.name != null) {
            if (this.value == null) {
                this.config.parseError(this.xmlProp, "You must specify a value with the name attribute");
            }
        } else if (this.file == null && this.env == null) {
            this.config.parseError(this.xmlProp, "You must specify file, or environment when not using the name attribute");
        }
        if (this.file == null && this.prefix != null) {
            this.config.parseError(this.xmlProp, "Prefix is only valid when loading from a file ");
        }
        if (this.name != null && this.value != null) {
            this.addProperty(this.name, this.value);
        } else if (this.file != null) {
            this.loadFile(this.file);
        } else if (this.env != null) {
            this.loadEnvironment(this.env);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFile(File file) throws CompilerException {
        block8: {
            Properties props = new Properties();
            this.config.getPackagerListener().packagerMsg("Loading " + file.getAbsolutePath(), 3);
            try {
                if (file.exists()) {
                    FileInputStream fis = new FileInputStream(file);
                    try {
                        props.load(fis);
                    }
                    finally {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    this.addProperties(props);
                    break block8;
                }
                this.config.getPackagerListener().packagerMsg("Unable to find property file: " + file.getAbsolutePath(), 3);
            }
            catch (IOException ex) {
                this.config.parseError(this.xmlProp, "Faild to load file: " + file.getAbsolutePath(), ex);
            }
        }
    }

    protected void loadEnvironment(String prefix) throws CompilerException {
        Properties props = new Properties();
        this.config.getPackagerListener().packagerMsg("Loading Environment " + prefix, 3);
        Vector osEnv = Execute.getProcEnvironment();
        Enumeration e = osEnv.elements();
        while (e.hasMoreElements()) {
            String entry = (String)e.nextElement();
            int pos = entry.indexOf(61);
            if (pos == -1) {
                this.config.getPackagerListener().packagerMsg("Ignoring " + prefix, 4);
                continue;
            }
            props.put(prefix + entry.substring(0, pos), entry.substring(pos + 1));
        }
        this.addProperties(props);
    }

    protected void addProperty(String name, String value) throws CompilerException {
        value = this.compiler.replaceProperties(value);
        this.compiler.addProperty(name, value);
    }

    protected void addProperties(Properties props) throws CompilerException {
        this.resolveAllProperties(props);
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = props.getProperty(name);
            if (this.prefix != null) {
                name = this.prefix + name;
            }
            this.addProperty(name, value);
        }
    }

    private void resolveAllProperties(Properties props) throws CompilerException {
        VariableSubstitutor subs = new VariableSubstitutor(props);
        subs.setBracesRequired(true);
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = props.getProperty(name);
            int mods = -1;
            do {
                StringReader read = new StringReader(value);
                StringWriter write = new StringWriter();
                try {
                    mods = subs.substitute(read, write, "at");
                    props.put(name, value);
                }
                catch (IOException ex) {
                    this.config.parseError(this.xmlProp, "Faild to load file: " + this.file.getAbsolutePath(), ex);
                }
            } while (mods != 0);
        }
    }
}

