/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.CustomData;
import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Panel;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.EtchedLineBorder;
import com.izforge.izpack.gui.IconsDatabase;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.installer.ResourceNotFoundException;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.installer.Unpacker;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.OsConstraint;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import net.n3.nanoxml.NonValidator;
import net.n3.nanoxml.StdXMLBuilder;
import net.n3.nanoxml.StdXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLElement;
import net.n3.nanoxml.XMLWriter;

public class InstallerFrame
extends JFrame {
    private static final long serialVersionUID = 3257852069162727473L;
    private static final float JAVA_SPECIFICATION_VERSION = Float.parseFloat(System.getProperty("java.specification.version"));
    public LocaleDatabase langpack;
    protected InstallData installdata;
    public IconsDatabase icons;
    protected JPanel panelsContainer;
    protected JPanel contentPane;
    protected JButton prevButton;
    protected JButton nextButton;
    protected JButton quitButton;
    private JLabel iconLabel;
    private int interruptCount = 1;
    private static final int MAX_INTERRUPT = 3;
    private boolean isBack = false;
    private Object usualFTP = null;
    private Object blockFTP = null;

    public InstallerFrame(String title, InstallData installdata) throws Exception {
        super(title);
        this.installdata = installdata;
        this.langpack = installdata.langpack;
        this.addWindowListener(new WindowHandler());
        this.setDefaultCloseOperation(0);
        this.loadIcons();
        this.loadPanels();
        this.buildGUI();
        this.showFrame();
        this.switchPanel(0);
    }

    private void loadPanels() throws Exception {
        List panelsOrder = this.installdata.panelsOrder;
        int size = panelsOrder.size();
        Class[] paramsClasses = new Class[]{Class.forName("com.izforge.izpack.installer.InstallerFrame"), Class.forName("com.izforge.izpack.installer.InstallData")};
        Object[] params = new Object[]{this, this.installdata};
        for (int i = 0; i < size; ++i) {
            Panel p = (Panel)panelsOrder.get(i);
            if (!OsConstraint.oneMatchesCurrentSystem(p.osConstraints)) continue;
            String className = p.className;
            String praefix = "com.izforge.izpack.panels.";
            if (className.compareTo(".") > -1) {
                praefix = "";
            }
            Class<?> objectClass = Class.forName(praefix + className);
            Constructor<?> constructor = objectClass.getDeclaredConstructor(paramsClasses);
            Object object = constructor.newInstance(params);
            IzPanel panel = (IzPanel)object;
            this.installdata.panels.add(panel);
            XMLElement panelRoot = new XMLElement(className);
            this.installdata.xmlData.addChild(panelRoot);
        }
    }

    private void loadIcons() throws Exception {
        ImageIcon img;
        URL url;
        XMLElement icon;
        int i;
        this.icons = new IconsDatabase();
        InputStream inXML = InstallerFrame.class.getResourceAsStream("/com/izforge/izpack/installer/icons.xml");
        StdXMLParser parser = new StdXMLParser();
        parser.setBuilder(new StdXMLBuilder());
        parser.setReader(new StdXMLReader(inXML));
        parser.setValidator(new NonValidator());
        XMLElement data = (XMLElement)parser.parse();
        Vector children = data.getChildrenNamed("icon");
        int size = children.size();
        for (i = 0; i < size; ++i) {
            icon = (XMLElement)children.get(i);
            url = (class$com$izforge$izpack$installer$InstallerFrame == null ? InstallerFrame.class$("com.izforge.izpack.installer.InstallerFrame") : class$com$izforge$izpack$installer$InstallerFrame).getResource(icon.getAttribute("res"));
            img = new ImageIcon(url);
            this.icons.put(icon.getAttribute("id"), img);
        }
        children = data.getChildrenNamed("sysicon");
        size = children.size();
        for (i = 0; i < size; ++i) {
            icon = (XMLElement)children.get(i);
            url = (class$com$izforge$izpack$installer$InstallerFrame == null ? InstallerFrame.class$("com.izforge.izpack.installer.InstallerFrame") : class$com$izforge$izpack$installer$InstallerFrame).getResource(icon.getAttribute("res"));
            img = new ImageIcon(url);
            UIManager.put(icon.getAttribute("id"), img);
        }
    }

    private void buildGUI() {
        this.setDefaultCloseOperation(0);
        this.setIconImage(this.icons.getImageIcon("JFrameIcon").getImage());
        JPanel glassPane = (JPanel)this.getGlassPane();
        glassPane.addMouseListener(new MouseAdapter(){});
        glassPane.addMouseMotionListener(new MouseMotionAdapter(){});
        glassPane.addKeyListener(new KeyAdapter(){});
        glassPane.addFocusListener(new FocusAdapter(){});
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        this.panelsContainer = new JPanel();
        this.panelsContainer.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.panelsContainer.setLayout(new GridLayout(1, 1));
        this.contentPane.add((Component)this.panelsContainer, "Center");
        this.installdata.curPanelNumber = 0;
        IzPanel panel_0 = (IzPanel)this.installdata.panels.get(0);
        this.panelsContainer.add(panel_0);
        NavigationHandler navHandler = new NavigationHandler();
        JPanel navPanel = new JPanel();
        navPanel.setLayout(new BoxLayout(navPanel, 0));
        navPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8), BorderFactory.createTitledBorder(new EtchedLineBorder(), this.langpack.getString("installer.madewith") + " ", 0, 0, new Font("Dialog", 0, 10))));
        navPanel.add(Box.createHorizontalGlue());
        this.prevButton = ButtonFactory.createButton(this.langpack.getString("installer.prev"), this.icons.getImageIcon("stepback"), this.installdata.buttonsHColor);
        navPanel.add(this.prevButton);
        this.prevButton.addActionListener(navHandler);
        navPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.nextButton = ButtonFactory.createButton(this.langpack.getString("installer.next"), this.icons.getImageIcon("stepforward"), this.installdata.buttonsHColor);
        navPanel.add(this.nextButton);
        this.nextButton.addActionListener(navHandler);
        navPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.quitButton = ButtonFactory.createButton(this.langpack.getString("installer.quit"), this.icons.getImageIcon("stop"), this.installdata.buttonsHColor);
        navPanel.add(this.quitButton);
        this.quitButton.addActionListener(navHandler);
        this.contentPane.add((Component)navPanel, "South");
        try {
            ImageIcon icon;
            ResourceManager rm = ResourceManager.getInstance();
            try {
                icon = rm.getImageIconResource("Installer.image");
            }
            catch (Exception e) {
                icon = rm.getImageIconResource("Installer.image.0");
            }
            if (icon != null) {
                JPanel imgPanel = new JPanel();
                imgPanel.setLayout(new BorderLayout());
                imgPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 0));
                this.iconLabel = new JLabel(icon);
                this.iconLabel.setBorder(BorderFactory.createLoweredBevelBorder());
                imgPanel.add((Component)this.iconLabel, "North");
                this.contentPane.add((Component)imgPanel, "West");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.loadImage(0);
        this.getRootPane().setDefaultButton(this.nextButton);
    }

    private void loadImage(int panelNo) {
        try {
            ResourceManager rm = ResourceManager.getInstance();
            ImageIcon icon = rm.getImageIconResource("Installer.image." + panelNo);
            if (icon != null) {
                this.iconLabel.setVisible(false);
                this.iconLabel.setIcon(icon);
                this.iconLabel.setVisible(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void showFrame() {
        this.pack();
        this.setSize(this.installdata.guiPrefs.width, this.installdata.guiPrefs.height);
        this.setResizable(this.installdata.guiPrefs.resizable);
        this.centerFrame(this);
        this.setVisible(true);
    }

    protected void switchPanel(int last) {
        try {
            if (this.installdata.curPanelNumber < last) {
                this.isBack = true;
            }
            this.panelsContainer.setVisible(false);
            IzPanel panel = (IzPanel)this.installdata.panels.get(this.installdata.curPanelNumber);
            IzPanel l_panel = (IzPanel)this.installdata.panels.get(last);
            if (this.installdata.curPanelNumber == 0) {
                this.prevButton.setVisible(false);
                this.lockPrevButton();
                this.unlockNextButton();
            } else if (this.installdata.curPanelNumber == this.installdata.panels.size() - 1) {
                this.prevButton.setVisible(false);
                this.nextButton.setVisible(false);
                this.lockNextButton();
                this.getRootPane().setDefaultButton(this.quitButton);
            } else {
                this.prevButton.setVisible(true);
                this.nextButton.setVisible(true);
                this.unlockPrevButton();
                this.unlockNextButton();
            }
            this.panelsContainer.remove(l_panel);
            l_panel.panelDeactivate();
            this.panelsContainer.add(panel);
            if (panel.getInitialFocus() != null) {
                JTextComponent inText;
                Component inFoc = panel.getInitialFocus();
                if ((double)JAVA_SPECIFICATION_VERSION < 1.35) {
                    inFoc.requestFocus();
                } else {
                    inFoc.requestFocusInWindow();
                }
                if (inFoc instanceof JTextComponent && (inText = (JTextComponent)inFoc).isEditable() && inText.getDocument() != null) {
                    inText.setCaretPosition(inText.getDocument().getLength());
                }
            }
            panel.panelActivate();
            this.panelsContainer.setVisible(true);
            this.loadImage(this.installdata.curPanelNumber);
            this.isBack = false;
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    private void writeUninstallData() {
        try {
            UninstallData udata = UninstallData.getInstance();
            List files = udata.getFilesList();
            ZipOutputStream outJar = this.installdata.uninstallOutJar;
            if (outJar == null) {
                return;
            }
            outJar.putNextEntry(new ZipEntry("install.log"));
            BufferedWriter logWriter = new BufferedWriter(new OutputStreamWriter(outJar));
            logWriter.write(this.installdata.getInstallPath());
            logWriter.newLine();
            Iterator iter = files.iterator();
            while (iter.hasNext()) {
                logWriter.write((String)iter.next());
                if (!iter.hasNext()) continue;
                logWriter.newLine();
            }
            logWriter.flush();
            outJar.closeEntry();
            outJar.putNextEntry(new ZipEntry("jarlocation.log"));
            logWriter = new BufferedWriter(new OutputStreamWriter(outJar));
            logWriter.write(udata.getUninstallerJarFilename());
            logWriter.newLine();
            logWriter.write(udata.getUninstallerPath());
            logWriter.flush();
            outJar.closeEntry();
            outJar.putNextEntry(new ZipEntry("executables"));
            ObjectOutputStream execStream = new ObjectOutputStream(outJar);
            iter = udata.getExecutablesList().iterator();
            execStream.writeInt(udata.getExecutablesList().size());
            while (iter.hasNext()) {
                ExecutableFile file = (ExecutableFile)iter.next();
                execStream.writeObject(file);
            }
            execStream.flush();
            outJar.closeEntry();
            Map additionalData = udata.getAdditionalData();
            if (additionalData != null && !additionalData.isEmpty()) {
                Iterator keys = additionalData.keySet().iterator();
                HashSet<String> exist = new HashSet<String>();
                while (keys != null && keys.hasNext()) {
                    int bytesInBuffer;
                    long bytesCopied;
                    byte[] buffer;
                    String key = (String)keys.next();
                    Object contents = additionalData.get(key);
                    if (key.equals("__uninstallLibs__")) {
                        Iterator nativeLibIter = ((List)contents).iterator();
                        while (nativeLibIter != null && nativeLibIter.hasNext()) {
                            String nativeLibName = (String)((List)nativeLibIter.next()).get(0);
                            buffer = new byte[5120];
                            bytesCopied = 0L;
                            outJar.putNextEntry(new ZipEntry("native/" + nativeLibName));
                            InputStream in = this.getClass().getResourceAsStream("/native/" + nativeLibName);
                            while ((bytesInBuffer = in.read(buffer)) != -1) {
                                outJar.write(buffer, 0, bytesInBuffer);
                                bytesCopied += (long)bytesInBuffer;
                            }
                            outJar.closeEntry();
                        }
                        continue;
                    }
                    if (key.equals("uninstallerListeners") || key.equals("uninstallerJars")) {
                        ArrayList<String> subContents = new ArrayList<String>();
                        Iterator listenerIter = ((List)contents).iterator();
                        while (listenerIter.hasNext()) {
                            buffer = new byte[5120];
                            bytesCopied = 0L;
                            CustomData customData = (CustomData)listenerIter.next();
                            if (customData.listenerName != null) {
                                subContents.add(customData.listenerName);
                            }
                            Iterator liClaIter = customData.contents.iterator();
                            while (liClaIter.hasNext()) {
                                String contentPath = (String)liClaIter.next();
                                if (exist.contains(contentPath)) continue;
                                exist.add(contentPath);
                                try {
                                    outJar.putNextEntry(new ZipEntry(contentPath));
                                }
                                catch (ZipException ze) {
                                    Debug.trace("ZipException in writing custom data: " + ze.getMessage());
                                    continue;
                                }
                                InputStream in = this.getClass().getResourceAsStream("/" + contentPath);
                                if (in != null) {
                                    while ((bytesInBuffer = in.read(buffer)) != -1) {
                                        outJar.write(buffer, 0, bytesInBuffer);
                                        bytesCopied += (long)bytesInBuffer;
                                    }
                                } else {
                                    Debug.trace("custom data not found: " + contentPath);
                                }
                                outJar.closeEntry();
                            }
                        }
                        outJar.putNextEntry(new ZipEntry(key));
                        ObjectOutputStream objOut = new ObjectOutputStream(outJar);
                        objOut.writeObject(subContents);
                        objOut.flush();
                        outJar.closeEntry();
                        continue;
                    }
                    outJar.putNextEntry(new ZipEntry(key));
                    if (contents instanceof ByteArrayOutputStream) {
                        ((ByteArrayOutputStream)contents).writeTo(outJar);
                    } else {
                        ObjectOutputStream objOut = new ObjectOutputStream(outJar);
                        objOut.writeObject(contents);
                        objOut.flush();
                    }
                    outJar.closeEntry();
                }
            }
            outJar.flush();
            outJar.close();
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    public InputStream getResource(String res) throws Exception {
        String basePath = "";
        ResourceManager rm = null;
        try {
            rm = ResourceManager.getInstance();
            rm.getClass();
            basePath = "/res/";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        InputStream result = this.getClass().getResourceAsStream(basePath + res);
        if (result == null) {
            throw new ResourceNotFoundException("Warning: Resource not found: " + res);
        }
        return result;
    }

    public void centerFrame(Window frame) {
        Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        Dimension frameSize = frame.getSize();
        frame.setLocation(center.x - frameSize.width / 2, center.y - frameSize.height / 2 - 10);
    }

    public Dimension getPanelsContainerSize() {
        return this.panelsContainer.getSize();
    }

    public void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, double wx, double wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    public void exit() {
        if (this.installdata.canClose) {
            this.writeUninstallData();
            Housekeeper.getInstance().shutDown(0);
        } else {
            if (Unpacker.isDiscardInterrupt() && this.interruptCount < 3) {
                ++this.interruptCount;
                return;
            }
            int res = JOptionPane.showConfirmDialog(this, this.langpack.getString("installer.quit.message"), this.langpack.getString("installer.quit.title"), 0);
            if (res == 0) {
                this.wipeAborted();
                Housekeeper.getInstance().shutDown(0);
            }
        }
    }

    protected void wipeAborted() {
        if (!Unpacker.interruptAll(40000L)) {
            return;
        }
        UninstallData u = UninstallData.getInstance();
        Iterator it = u.getFilesList().iterator();
        if (!it.hasNext()) {
            return;
        }
        while (it.hasNext()) {
            String p = (String)it.next();
            File f = new File(p);
            f.delete();
        }
        String fullCleanup = this.installdata.getVariable("InstallerFrame.cleanAllAtInterrupt");
        if (fullCleanup == null || !fullCleanup.equalsIgnoreCase("no")) {
            this.cleanWipe(new File(this.installdata.getInstallPath()));
        }
    }

    private void cleanWipe(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            int size = files.length;
            for (int i = 0; i < size; ++i) {
                this.cleanWipe(files[i]);
            }
        }
        file.delete();
    }

    public void install(AbstractUIProgressHandler listener) {
        Unpacker unpacker = new Unpacker(this.installdata, listener);
        unpacker.start();
    }

    public void writeXMLTree(XMLElement root, OutputStream out) throws Exception {
        XMLWriter writer = new XMLWriter(out);
        for (int i = 0; i < this.installdata.panels.size(); ++i) {
            IzPanel panel = (IzPanel)this.installdata.panels.get(i);
            panel.makeXMLData(this.installdata.xmlData.getChildAtIndex(i));
        }
        writer.write(this.installdata.xmlData);
    }

    public void setQuitButtonText(String text) {
        if (text == null) {
            text = this.langpack.getString("installer.quit");
        }
        this.quitButton.setText(text);
    }

    public void blockGUI() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.getGlassPane().setVisible(true);
        this.getGlassPane().setEnabled(true);
        if ((double)JAVA_SPECIFICATION_VERSION < 1.35) {
            return;
        }
        if (this.usualFTP == null) {
            this.usualFTP = this.getFocusTraversalPolicy();
        }
        if (this.blockFTP == null) {
            this.blockFTP = new BlockFocusTraversalPolicy();
        }
        this.setFocusTraversalPolicy((FocusTraversalPolicy)this.blockFTP);
        this.getGlassPane().requestFocus();
    }

    public void releaseGUI() {
        this.getGlassPane().setEnabled(false);
        this.getGlassPane().setVisible(false);
        this.setCursor(Cursor.getPredefinedCursor(0));
        if ((double)JAVA_SPECIFICATION_VERSION < 1.35) {
            return;
        }
        this.setFocusTraversalPolicy((FocusTraversalPolicy)this.usualFTP);
    }

    public void lockPrevButton() {
        this.prevButton.setEnabled(false);
    }

    public void lockNextButton() {
        this.nextButton.setEnabled(false);
    }

    public void unlockPrevButton() {
        this.prevButton.setEnabled(true);
    }

    public void unlockNextButton() {
        this.nextButton.setEnabled(true);
        this.nextButton.requestFocus();
    }

    public void skipPanel() {
        if (this.installdata.curPanelNumber < this.installdata.panels.size() - 1) {
            if (this.isBack) {
                --this.installdata.curPanelNumber;
                this.switchPanel(this.installdata.curPanelNumber + 1);
            } else {
                ++this.installdata.curPanelNumber;
                this.switchPanel(this.installdata.curPanelNumber - 1);
            }
        }
    }

    public void navigateNext() {
        if (!this.nextButton.isEnabled()) {
            return;
        }
        if (this.installdata.curPanelNumber < this.installdata.panels.size() - 1 && ((IzPanel)this.installdata.panels.get(this.installdata.curPanelNumber)).isValidated()) {
            ++this.installdata.curPanelNumber;
            this.switchPanel(this.installdata.curPanelNumber - 1);
        }
    }

    public void navigatePrevious() {
        if (!this.prevButton.isEnabled()) {
            return;
        }
        if (this.installdata.curPanelNumber > 0) {
            --this.installdata.curPanelNumber;
            this.switchPanel(this.installdata.curPanelNumber + 1);
        }
    }

    private class BlockFocusTraversalPolicy
    extends DefaultFocusTraversalPolicy {
        private static final long serialVersionUID = 3258413928261169209L;

        private BlockFocusTraversalPolicy() {
        }

        protected boolean accept(Component aComp) {
            return aComp == InstallerFrame.this.getGlassPane();
        }
    }

    class WindowHandler
    extends WindowAdapter {
        WindowHandler() {
        }

        public void windowClosing(WindowEvent e) {
            InstallerFrame.this.exit();
        }
    }

    class NavigationHandler
    implements ActionListener {
        NavigationHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == InstallerFrame.this.prevButton) {
                InstallerFrame.this.navigatePrevious();
            } else if (source == InstallerFrame.this.nextButton) {
                InstallerFrame.this.navigateNext();
            } else if (source == InstallerFrame.this.quitButton) {
                InstallerFrame.this.exit();
            }
        }
    }
}

