/* Copyright 2006, Jeremy Brooks <jeremyb@whirljack.net>
 *
 * This file is part of Scrip du Jour.
 *
 * Scrip du Jour is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * Scrip du Jour is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with Foobar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package net.whirljack.sdj;

// JAVA I/O
import java.io.File;

// SDJ
import net.whirljack.sdj.bo.SDJRootElement;

// XML
import org.xml.sax.helpers.DefaultHandler;

/**
 * Parse a Scrip du Jour XML file, finding the root element.
 *
 * @author jeremyb
 */
public class RootElementParseHandler extends DefaultHandler {

    /** Object representing the root element. */
    private SDJRootElement root = null;
    /** The file to parse. */
    private File file = null;

    /** No kitty that's a bad kitty! */
    private RootElementParseHandler() {
    }

    /**
     * Creates a new instance of RootElementParseHandler.
     * @param filename the file to parse.
     */
    public RootElementParseHandler(File filename) {
        this.file = filename;
    }

    /**
     * Handle a start element event.
     * We only care about the "document" element.  When it is found,
     * we set the attributes in our root element object, and that's it.
     */
    @Override
    public void startElement(
            String uri,
            String localName,
            String qName, org.xml.sax.Attributes attributes)
            throws org.xml.sax.SAXException {

        if (qName.equals("document")) {
            this.root = new SDJRootElement();
            this.root.setFile(this.file);
            this.root.setDescription(attributes.getValue("description"));
            this.root.setShortDescription(attributes.getValue("shortDescription"));
            this.root.setIgnoreYear(new Boolean(attributes.getValue("ignoreYear")));
        }

    }

    /**
     * Get the object representing the root element.
     * @return object representing the root element.
     */
    public SDJRootElement getSDJRootElement() {
        return this.root;
    }
}
