/* Copyright 2006-2009, Jeremy Brooks <jeremyb@whirljack.net>
 *
 * This file is part of Scrip du Jour.
 *
 * Scrip du Jour is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * Scrip du Jour is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with Foobar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package net.whirljack.sdj;

import net.whirljack.sdj.gui.MainWindow;

/**
 * This class will run when the JVM is shutting down.
 *
 * @author jeremyb
 */
public class ShutdownHook implements Runnable {

    /** Reference to the main window. */
    private MainWindow mainWindow;


    /**
     * Constructor.
     *
     * @param mainWindow reference to the main window.
     */
    public ShutdownHook(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
    }


    /**
     * Tasks to execute at shutdown.
     */
    public void run() {

        // save the position and size of the main window
        this.mainWindow.savePositionAndSize();
    }

}
