/* Copyright 2006, Jeremy Brooks <jeremyb@whirljack.net>
 *
 * This file is part of Scrip du Jour.
 *
 * Scrip du Jour is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * Scrip du Jour is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with Foobar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package net.whirljack.sdj;

// JAVA I/O
import java.io.BufferedReader;
import java.io.InputStreamReader;

// JAVA NETWORKING
import java.net.URL;
import java.net.HttpURLConnection;

// LOGGING
import org.apache.log4j.Logger;

// SDJ
import net.whirljack.sdj.gui.MainWindow;

/**
 * Check for a new version of the program.
 *
 * @author jeremyb
 */
public class VersionChecker implements Runnable {

    /** Logging. */
    private Logger logger = Logger.getLogger(VersionChecker.class);

    /** The URL where version info is found. */
    private static final String VERSION_URL = "http://www.whirljack.net/software/scripdujour/VERSION";

    /** Reference to the main window. */
    private MainWindow mainWindow = null;


    /** Creates a new instance of VersionChecker.
     *
     * @param mainWindow reference to the applications main window.
     */
    public VersionChecker(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
    }


    /**
     * Run loop for the Runnable.
     *
     * <p>This method will check to see if there is a new version available.
     * It runs as a separate Thread so that it will not block the GUI if the
     * network connection is slow or missing.</p>
     */
    public void run() {
        HttpURLConnection conn = null;
        BufferedReader in = null;
        String latestVersion = null;


        try {
            // WAIT A LITTLE BIT TO MAKE SURE THE MAIN WINDOW IS INSTANSIATED
            Thread.sleep(2000);

            // GET THE VERSION WEB PAGE
            conn = (HttpURLConnection) new URL(VERSION_URL).openConnection();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            latestVersion = in.readLine();

            logger.debug("Got version " + latestVersion + " from " + VERSION_URL);

            if (latestVersion.compareTo(SDJMain.VERSION) == 1) {
                mainWindow.newVersionAvailable();
            }

        } catch (Exception e) {
            logger.warn("ERROR WHILE CHECKING FOR A NEW VERSION.", e);
        } finally {
            FileUtil.close(in);
            conn.disconnect();
        }

    }
}
