/* Copyright 2006, Jeremy Brooks <jeremyb@whirljack.net>
 *
 * This file is part of Scrip du Jour.
 *
 * Scrip du Jour is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * Scrip du Jour is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with Foobar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package net.whirljack.sdj.bo;

/**
 * Object representing an entry element of a Scrip du Jour XML file.
 * 
 * When rendered, the element should look like this:
 *
 * <entry date="" read="">
 *   <heading></heading>
 *   <text></text>
 * </entry>
 *
 * @author jeremyb
 */
public class SDJEntryElement {

    /** The date of this entry, in YYYYMMDD format. */
    private String date;

    /** Flag indicating if this entry has been read. */
    private boolean read;

    /** The heading element of this entry element. */
    private String heading;

    /** The text element of this entry element. */
    private String text;


    /**
     * Create a new SDJEntryElement and initialize the values.
     */
    public SDJEntryElement() {
        this.date = "";
        this.read = false;
        this.heading = "";
        this.text = "";
    }


    /**
     * Get the date.
     * @return date attribute of this entry element.
     */
    public String getDate() {
        return date;
    }


    /**
     * Set the date.
     * @param date the date attribute of this entry element.
     */
    public void setDate(String date) {
        this.date = date;
    }


    /**
     * Get the read flag.
     * @return true if this entry has been read.
     */
    public boolean isRead() {
        return read;
    }


    /**
     * Set the read flag.
     * @param read the status of the read flag.
     */
    public void setRead(boolean read) {
        this.read = read;
    }


    /**
     * Get heading.
     * @return value of the heading element.
     */
    public String getHeading() {
        return heading;
    }


    /**
     * Set heading.
     * @param heading the value of the heading element.
     */
    public void setHeading(String heading) {
        this.heading = heading;
    }


    /**
     * Get text.
     * @return value of the text element.
     */
    public String getText() {
        return text;
    }
    

    /**
     * Set text.
     * @param text the value to set as the text element.
     */
    public void setText(String text) {
        this.text = text;
    }
}
