/* Copyright 2006, Jeremy Brooks <jeremyb@whirljack.net>
 *
 * This file is part of Scrip du Jour.
 *
 * Scrip du Jour is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * Scrip du Jour is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with Foobar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package net.whirljack.sdj.bo;

// JAVA I/O
import java.io.File;


/**
 * Object representing the root element of a Scrip du Jour XML file.
 *
 * When rendered, the root element should look like this:
 *
 * <document description="" shortDescription="" ignoreYear=""/>
 *
 * Note that there is a file attribute in here, but that is strictly for 
 * convenience.  It is not rendered to the XML file.
 *
 * @author jeremyb
 */
public class SDJRootElement {

    /** The file we were read from. */
    private File file = null;

    /** The description attribute of the root element. */
    private String description = "";

    /** The shortDescription attribute of the root element. */
    private String shortDescription = "";

    /** The ignoreYear attribute of the root element. */
    private boolean ignoreYear = false;


    /**
     * Creates a new instance of SDJRootElement.
     */
    public SDJRootElement() {
    }


    /**
     * Get file.
     * @return the file this root element was found in.
     */
    public File getFile() {
        return file;
    }


    /**
     * Set file.
     * @param file set the file attribute.
     */
    public void setFile(File file) {
        this.file = file;
    }


    /**
     * Get description.
     * @return value of the description attribute.
     */
    public String getDescription() {
        return description;
    }


    /**
     * Set description.
     * @param description the value of the description attribute.
     */
    public void setDescription(String description) {
        this.description = description;
    }


    /**
     * Get short description.
     * @return value of the shortDescription attribute.
     */
    public String getShortDescription() {
        return shortDescription;
    }


    /**
     * Set short description.
     * @param shortDescription the value of the shortDescription attribute.
     */
    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }


    /**
     * Get state of the ignoreYear flag.
     * @return true if the year part of the date should be ignored.
     */
    public boolean isIgnoreYear() {
        return ignoreYear;
    }


    /**
     * Set state of the ignoreYear flag.
     * @param ignoreYear value of the ignoreYear attribute.
     */
    public void setIgnoreYear(boolean ignoreYear) {
        this.ignoreYear = ignoreYear;
    }
}
