/* Copyright 2006, Jeremy Brooks <jeremyb@whirljack.net>
 *
 * This file is part of Scrip du Jour.
 *
 * Scrip du Jour is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * Scrip du Jour is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with Foobar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package net.whirljack.sdj.gui;

// JAVA AWT
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;

// SDJ
import net.whirljack.sdj.SDJMain;
import net.whirljack.sdj.FileUtil;

// LOGGING
import org.apache.log4j.Logger;

/**
 * The about dialog box for Scrip du Jour.
 * It should display the splash screen logo, the version, and a brief message
 * including contact information.
 *
 * @author  jeremyb
 */
public class AboutDialog extends javax.swing.JDialog {

    /** Logging. */
    private Logger logger = Logger.getLogger(AboutDialog.class);

    /**
     * Creates new form AboutDialog
     *
     * @param parent
     * @param modal
     */
    public AboutDialog(Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();

        // put the cursor at the beginning of the about stuff
        this.jTextArea1.setSelectionStart(1);
        this.jTextArea1.setCaretPosition(0);
        this.helpTextArea.setCaretPosition(0);

        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension windowSize = this.getPreferredSize();
        setLocation(screenSize.width / 2 - (windowSize.width / 2),
                screenSize.height / 2 - (windowSize.height / 2));
    }


    /**
     * This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel1 = new javax.swing.JLabel();
        jButton1 = new javax.swing.JButton();
        versionLabel = new javax.swing.JLabel();
        jTabbedPane1 = new javax.swing.JTabbedPane();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTextArea1 = new javax.swing.JTextArea();
        jScrollPane3 = new javax.swing.JScrollPane();
        helpTextArea = new javax.swing.JTextArea();
        jScrollPane2 = new javax.swing.JScrollPane();
        licenseTextArea = new javax.swing.JTextArea();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("About Scrip du Jour");
        setAlwaysOnTop(true);
        setModal(true);
        getContentPane().setLayout(new java.awt.GridBagLayout());

        jLabel1.setIcon(new javax.swing.ImageIcon(getClass().getResource("/net/whirljack/sdj/images/splash.png"))); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(jLabel1, gridBagConstraints);

        jButton1.setText("OK");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(jButton1, gridBagConstraints);

        versionLabel.setText("Scrip du Jour version " + SDJMain.VERSION);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(versionLabel, gridBagConstraints);

        jTextArea1.setEditable(false);
        jTextArea1.setLineWrap(true);
        jTextArea1.setRows(10);
        jTextArea1.setText("Scrip du Jour is a program to make it easy to read something every day.  It gets data from xml files, which can contain any text.  Scrip du Jour is copyright 2006-2010 by Jeremy Brooks, and is distributed under the terms of the Gnu General Public License, version 2.  \n\nThis program uses the log4j library from the Apache foundation and BrowserLauncher from Eric Albert.\n\nThanks to Patrick McIlhenny for coming up with a name for the program.\n\nFor support or questions, contact jeremyb@whirljack.net.\n\n\nCHANGELOG:\nVersion 1.4.1\n10-JAN-2011\n * Using the latest version of the Knicker library for word definition lookup.\n\nVersion 1.4.0\n22-OCT-2010\n * Added right-click context menu.\n * Added ability to define a selected word.\n * Use fast splash screen.\n * Now requires Java 1.6 or higher.\n\nVersion 1.3.1\n7-DEC-2009\n * Added font size option to preferences dialog.\n * Save the window position and size when the program exits.\n * Restore window position and size when the program starts.\n\nVersion 1.3.0\n30-NOV-2009\n * Updated Mac package to use Intel JavaApplicationStub.\n * Updated the icons in the menus and toolbar.\n * Various tweaks to be more Mac-like on the Mac platform.\n * Commenting and cleanup.\n * Use latest version of log4j.\n\nVersion 1.2.1\n1/10/2007\n * Fixed ignore year logic in find first unread item.\n\nVersion 1.2.0\n12/5/2006\n * Added count of unread items older than the current day.\n * Added find first unread item.\n * Added ability to display window at a certain time each day.\n * Window is slightly bigger.\n * Cursor moves to the beginning of document when you change days.\n * Improved performance.\n\nVersion 1.1.0\n2/4/2006\n * This program is now called Scrip du Jour, rather than Daily Reader.\n   Thank you Patrick McIlhenny for the name suggestion.\n * Added better display of date to main window.\n * Fixed some typos.\n * Replaced literal \\n with System.getProperty(\"line.separator\")\n * Fixed a bug where the wait dialog was not centered in the parent window.\n * Added week & month navigation to view menu.\n * Added ability to check for updates automatically.\n * Added ability to launch browser to download update.\n\nVersion 1.0.0\n1/19/2006\n * Editor is working, and can edit existing files or create new files.\n * Custom icons and splash screen.\n * Cleaned up the code.\n * Added better feedback during long operations.\n * Added inset to tab panels to make the text more readable.\n");
        jTextArea1.setWrapStyleWord(true);
        jTextArea1.setMargin(new java.awt.Insets(3, 3, 3, 3));
        jScrollPane1.setViewportView(jTextArea1);

        jTabbedPane1.addTab("Credits", jScrollPane1);

        helpTextArea.setColumns(20);
        helpTextArea.setEditable(false);
        helpTextArea.setLineWrap(true);
        helpTextArea.setRows(5);
        helpTextArea.setText("There are several options in the Preferences dialog for Scrip Du Jour.\n\nTo check for updates automatically, check the \"Check for Updates At Startup\" box.  This will connect to the Scrip du Jour home page, and see if there is a newer version.  No information is sent from your computer during this check.\n\nTo have Scrip du Jour pop up every day, you can put it in the startup items for your computer.  If you don't log in every day, you can use the Alarm Clock Mode.\n\nIf you enable Alarm Clock Mode, Scrip du Jour will continue to run after you close it, but will become visible again at the time you specify in the preferences dialog.  It can hide the window by minimizing it (which will cause the Scrip du Jour window to stay in your taskbar/dock as a minimized window), or by hiding it.  If you choose to hide the Scrip du Jour window, you will not be able to access the window again until it comes up automatically.\n\nIf you need help, or have suggestions, you can email jeremyb@whirljack.net.\n");
        helpTextArea.setWrapStyleWord(true);
        jScrollPane3.setViewportView(helpTextArea);

        jTabbedPane1.addTab("Help", jScrollPane3);

        licenseTextArea.setEditable(false);
        licenseTextArea.setLineWrap(true);
        licenseTextArea.setRows(15);
        licenseTextArea.setText("license");
        licenseTextArea.setWrapStyleWord(true);
        this.populateLicenseTextArea();
        jScrollPane2.setViewportView(licenseTextArea);

        jTabbedPane1.addTab("License", jScrollPane2);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(jTabbedPane1, gridBagConstraints);

        pack();
    }// </editor-fold>//GEN-END:initComponents


	private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
            this.setVisible(false);
            this.dispose();
	}//GEN-LAST:event_jButton1ActionPerformed


    /**
     * Read the license file and put it in the text area.
     */
    private void populateLicenseTextArea() {
        BufferedReader in = null;
        InputStream is = null;
        try {
            String line = null;
            StringBuffer buf = new StringBuffer();
            is = this.getClass().getClassLoader().getResourceAsStream("net/whirljack/sdj/LICENSE.txt");
            in = new BufferedReader(new InputStreamReader(is));
            while ((line = in.readLine()) != null) {
                buf.append(line);
                buf.append(System.getProperty("line.separator"));
            }
            this.licenseTextArea.setText(buf.toString());

        } catch (Exception e) {
            logger.error("ERROR DISPLAYING LICENSE.", e);

            this.licenseTextArea.setText("There was an error while trying to display the license." + System.getProperty("line.separator") + "A copy of the license was included with this program." + System.getProperty("line.separator") + "You can also view the text of the license at:" + System.getProperty("line.separator") + "http://www.gnu.org/copyleft/gpl.html");
        } finally {
            this.licenseTextArea.setCaretPosition(0);
            FileUtil.close(is);
            FileUtil.close(in);
        }
    }


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextArea helpTextArea;
    private javax.swing.JButton jButton1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JTabbedPane jTabbedPane1;
    private javax.swing.JTextArea jTextArea1;
    private javax.swing.JTextArea licenseTextArea;
    private javax.swing.JLabel versionLabel;
    // End of variables declaration//GEN-END:variables
}
