/* Copyright 2006-2009, Jeremy Brooks <jeremyb@whirljack.net>
 *
 * This file is part of Scrip du Jour.
 *
 * Scrip du Jour is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * Scrip du Jour is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with Foobar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package net.whirljack.sdj.gui;

// APPLE STUFF
import com.apple.eawt.ApplicationEvent;
import com.apple.eawt.Application;
import com.apple.eawt.ApplicationListener;

// JFRAME
import javax.swing.JFrame;
import net.whirljack.sdj.PropertyManager;


/**
 * Handle Mac-specific events.
 *
 * @author jeremyb
 */
public class MacOSEventHandler extends Application {


    /**
     * Create a new instance of MacOSEventHandler
     * and register as an application listener.
     */
    public MacOSEventHandler() {
        addApplicationListener(new MacEventHandler());
    }


    /**
     * Implement the ApplicationListener interface.
     *
     * <p>We handle the About and Quit events.</p>
     */
    class MacEventHandler implements ApplicationListener {


        /**
         * Handle the About event.
         *
         * @param event the application event.
         */
        @Override
        public void handleAbout(ApplicationEvent event) {
            new AboutDialog(new JFrame(), true).setVisible(true);
            event.setHandled(true);
        }

        
        /**
         * Handle the Quit event.
         *
         * @param event the application event.
         */
        @Override
        public void handleQuit(ApplicationEvent event) {
            
            System.exit(0);
        }


        /**
         * Handle the OpenApplication event.
         *
         * <p>Currently, we do not do anything with this event.</p>
         *
         * @param event the application event.
         */
        public void handleOpenApplication(ApplicationEvent event) {
        }


        /**
         * Handle the OpenFile event.
         *
         * <p>Currently, we do not do anything with this event.</p>
         *
         * @param event the application event.
         */
        public void handleOpenFile(ApplicationEvent event) {
        }


        /**
         * Handle the Preferences event.
         *
         * <p>Currently, we do not do anything with this event.</p>
         *
         * @param event the application event.
         */
        public void handlePreferences(ApplicationEvent event) {

        }


        /**
         * Handle the PrintFile event.
         *
         * <p>Currently, we do not do anything with this event.</p>
         *
         * @param event the application event.
         */
        public void handlePrintFile(ApplicationEvent event) {
        }


        /**
         * Handle the ReOpenApplication event.
         *
         * <p>Currently, we do not do anything with this event.</p>
         *
         * @param event the application event.
         */
        public void handleReOpenApplication(ApplicationEvent event) {
        }

    }
}
