/* Copyright 2006, Jeremy Brooks <jeremyb@whirljack.net>
 *
 * This file is part of Scrip du Jour.
 *
 * Scrip du Jour is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 
 * Scrip du Jour is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 
 * You should have received a copy of the GNU General Public License
 * along with Foobar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package net.whirljack.sdj.gui;

// JAVA UTILITY
import java.awt.Frame;
import java.util.List;
import java.util.StringTokenizer;

// JAVA SWING
import javax.swing.JOptionPane;

// LOGGING
import org.apache.log4j.Logger;

// SDJ STUFF
import net.whirljack.sdj.PropertyManager;


/**
 * Allow the user to set various preferences.
 * Settings will be saved for future use.
 *
 * @author  jeremyb
 */
public class PreferencesDialog extends javax.swing.JDialog {
    
    /** Logging. */
    Logger logger = Logger.getLogger(PreferencesDialog.class);
    
    /** Object used for the JSpinner representing hours. */
    private Object[] hours = new Object[24];
    
    /** Object used for the JSpinner representing minutes. */
    private Object[] minutes = new Object[60];

    /**The initial font size shown in the dialog. */
    private Object initialFontSize;

    /** 
     * Creates new form PreferencesDialog.
     * The state will be set from the currently saved preferences.
     * @param parent
     * @param modal 
     */
    public PreferencesDialog(Frame parent, boolean modal) {
	super(parent, modal);
	
	// POPULATE THE HOURS AND MINUTES OBJECTS
	for (int i = 0; i < 24; i++) {
	    hours[i] = new Integer(i);
	}
	for (int i = 0; i < 60; i++) {
	    minutes[i] = new Integer(i);
	}
	
	initComponents();
	
	// FIGURE OUT HOUR AND MINUTE
	Integer h = 0;
	Integer m = 0;
	try {
	    String time = PropertyManager.getInstance().getProperty(PropertyManager.PROPERTY_ALARM_CLOCK_TIME);
	    StringTokenizer tok = new StringTokenizer(time, ".");
	    String hour = tok.nextToken();
	    String minute = tok.nextToken();
	    h = new Integer(hour);
	    m = new Integer(minute);
	    
	} catch (Exception e) {
	    
	    logger.error("There was an error creating the preferences dialog.", e);
	    
	    JOptionPane.showMessageDialog(this, 
		    "There was an error creating the Preferences dialog."
		    + System.getProperty("line.separator")
		    + "The error was: " + e.getMessage(),
		    "Error",
		    JOptionPane.ERROR_MESSAGE);
	}
	
	this.spnHour.setValue(h);
	this.spnMinute.setValue(m);
	
	
	this.cbxUpdates.setSelected(PropertyManager.getInstance().getPropertyAsBoolean(PropertyManager.PROPERTY_CHECK_FOR_UPDATES));
	this.cbxAlarm.setSelected(PropertyManager.getInstance().getPropertyAsBoolean(PropertyManager.PROPERTY_ALARM_CLOCK_MODE));
	if (PropertyManager.getInstance().getProperty(PropertyManager.PROPERTY_WINDOW_HIDE_MODE).equals(PropertyManager.MODE_HIDE)) {
	    this.btnHide.setSelected(true);
	} else {
	    this.btnMinimize.setSelected(true);
	}
	boolean selected = this.cbxAlarm.isSelected();
	this.spnHour.setEnabled(selected);
	this.spnMinute.setEnabled(selected);
	this.lblTime.setEnabled(selected);
	this.lblHide.setEnabled(selected);
	this.btnHide.setEnabled(selected);
	this.btnMinimize.setEnabled(selected);
	
	getRootPane().setDefaultButton(this.btnOk);

        this.initialFontSize = this.cmbFont.getSelectedItem();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();
        btnOk = new javax.swing.JButton();
        btnCancel = new javax.swing.JButton();
        jPanel1 = new javax.swing.JPanel();
        cbxUpdates = new javax.swing.JCheckBox();
        jPanel2 = new javax.swing.JPanel();
        cbxAlarm = new javax.swing.JCheckBox();
        lblTime = new javax.swing.JLabel();
        lblHide = new javax.swing.JLabel();
        spnHour = new javax.swing.JSpinner();
        jLabel1 = new javax.swing.JLabel();
        spnMinute = new javax.swing.JSpinner();
        btnMinimize = new javax.swing.JRadioButton();
        btnHide = new javax.swing.JRadioButton();
        jPanel3 = new javax.swing.JPanel();
        cmbFont = new javax.swing.JComboBox();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        setTitle("ScripDuJour Preferences");
        setAlwaysOnTop(true);

        btnOk.setText("OK");
        btnOk.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnOkActionPerformed(evt);
            }
        });

        btnCancel.setText("Cancel");
        btnCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnCancelActionPerformed(evt);
            }
        });

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("Updates"));

        cbxUpdates.setText("Check for Updates At Startup");
        cbxUpdates.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        cbxUpdates.setMargin(new java.awt.Insets(0, 0, 0, 0));

        org.jdesktop.layout.GroupLayout jPanel1Layout = new org.jdesktop.layout.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .add(cbxUpdates)
                .addContainerGap(139, Short.MAX_VALUE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .add(cbxUpdates)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder("Alarm Clock Mode"));

        cbxAlarm.setText("Enable Alarm Clock Mode");
        cbxAlarm.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        cbxAlarm.setMargin(new java.awt.Insets(0, 0, 0, 0));
        cbxAlarm.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cbxAlarmActionPerformed(evt);
            }
        });

        lblTime.setText("Display every day at this time:");

        lblHide.setText("Window hiding:");

        spnHour.setModel(new CyclingSpinnerListModel(hours));

        jLabel1.setText(":");

        spnMinute.setModel(new CyclingSpinnerListModel(minutes));

        buttonGroup1.add(btnMinimize);
        btnMinimize.setText("Minimize");
        btnMinimize.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        btnMinimize.setMargin(new java.awt.Insets(0, 0, 0, 0));

        buttonGroup1.add(btnHide);
        btnHide.setText("Hide");
        btnHide.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        btnHide.setMargin(new java.awt.Insets(0, 0, 0, 0));

        org.jdesktop.layout.GroupLayout jPanel2Layout = new org.jdesktop.layout.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel2Layout.createSequentialGroup()
                        .add(22, 22, 22)
                        .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                            .add(lblHide)
                            .add(lblTime))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(btnHide)
                            .add(jPanel2Layout.createSequentialGroup()
                                .add(spnHour, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 45, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(jLabel1)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(spnMinute, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 43, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                            .add(btnMinimize)))
                    .add(cbxAlarm))
                .addContainerGap(22, Short.MAX_VALUE))
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .add(cbxAlarm)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(lblTime)
                    .add(spnHour, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(spnMinute, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel1))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(lblHide)
                    .add(btnMinimize))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(btnHide)
                .addContainerGap(57, Short.MAX_VALUE))
        );

        jPanel3.setBorder(javax.swing.BorderFactory.createTitledBorder("Font Size"));

        cmbFont.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "8", "10", "12", "14", "18", "20", "24", "30", "36" }));
        cmbFont.setSelectedItem(PropertyManager.getInstance().getProperty(PropertyManager.PROPERTY_FONT_SIZE));
        cmbFont.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cmbFontActionPerformed(evt);
            }
        });
        cmbFont.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                cmbFontPropertyChange(evt);
            }
        });

        jLabel2.setText("This font size will be used for the");

        jLabel3.setText("main window heading and text display.");

        org.jdesktop.layout.GroupLayout jPanel3Layout = new org.jdesktop.layout.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .add(cmbFont, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabel3)
                    .add(jLabel2))
                .addContainerGap(20, Short.MAX_VALUE))
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel3Layout.createSequentialGroup()
                .add(jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(cmbFont, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel2))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jLabel3)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                            .add(org.jdesktop.layout.GroupLayout.LEADING, jPanel3, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .add(org.jdesktop.layout.GroupLayout.LEADING, layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
                                .add(org.jdesktop.layout.GroupLayout.LEADING, jPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .add(org.jdesktop.layout.GroupLayout.LEADING, jPanel2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                        .addContainerGap())
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                        .add(btnCancel)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(btnOk)
                        .add(9, 9, 9))))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(3, 3, 3)
                .add(jPanel2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel3, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(btnOk)
                    .add(btnCancel))
                .add(48, 48, 48))
        );

        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setBounds((screenSize.width-374)/2, (screenSize.height-416)/2, 374, 416);
    }// </editor-fold>//GEN-END:initComponents

    
    /**
     * Handle clicks on the OK button.
     * When the user clicks on the OK button, settings will be saved,
     * and the preferences dialog will be closed.
     */
    private void btnOkActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnOkActionPerformed
	if (this.cbxAlarm.isSelected()) {
	    PropertyManager.getInstance().setProperty(PropertyManager.PROPERTY_ALARM_CLOCK_MODE, "true");
	    String time = (this.spnHour.getValue().toString()) + "." + (this.spnMinute.getValue().toString());
	    PropertyManager.getInstance().setProperty(PropertyManager.PROPERTY_ALARM_CLOCK_TIME, time);
	} else {
	    PropertyManager.getInstance().setProperty(PropertyManager.PROPERTY_ALARM_CLOCK_MODE, "false");
	    
	}
	
	if (this.cbxUpdates.isSelected()) {
	    PropertyManager.getInstance().setProperty(PropertyManager.PROPERTY_CHECK_FOR_UPDATES, "true");
	} else {
	    PropertyManager.getInstance().setProperty(PropertyManager.PROPERTY_CHECK_FOR_UPDATES, "false");
	}
	
	if (this.btnHide.isSelected()) {
	    PropertyManager.getInstance().setProperty(PropertyManager.PROPERTY_WINDOW_HIDE_MODE, PropertyManager.MODE_HIDE);
	} else {
	    PropertyManager.getInstance().setProperty(PropertyManager.PROPERTY_WINDOW_HIDE_MODE, PropertyManager.MODE_MINIMIZE);
	}

        PropertyManager.getInstance().setProperty(PropertyManager.PROPERTY_FONT_SIZE, this.cmbFont.getSelectedItem().toString());

        this.setVisible(false);
	this.dispose();
    }//GEN-LAST:event_btnOkActionPerformed

    
    /**
     * Handle clicks on the Cancel button.
     * When the user clicks the Cancel button, settings will not be
     * saved, and the preferences dialog is closed.
     *
     */
    private void btnCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnCancelActionPerformed

        // restore the font size
        this.cmbFont.setSelectedItem(this.initialFontSize);
	this.setVisible(false);
	this.dispose();
    }//GEN-LAST:event_btnCancelActionPerformed

    
    /**
     * When the user clicks the Alarm box, set state accordingly. 
     */
    private void cbxAlarmActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cbxAlarmActionPerformed
	boolean selected = this.cbxAlarm.isSelected();
	this.spnHour.setEnabled(selected);
	this.spnMinute.setEnabled(selected);
	this.lblTime.setEnabled(selected);
	this.lblHide.setEnabled(selected);
	this.btnHide.setEnabled(selected);
	this.btnMinimize.setEnabled(selected);
	
    }//GEN-LAST:event_cbxAlarmActionPerformed



    /**
     * Respond to changes in the font size.
     *
     * <p>When the user changes the font size, the size in all displayed tabs
     * is updated. This update will be visible when the user closes the
     * properties dialog.</p>
     * 
     * @param evt
     */
    private void cmbFontPropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_cmbFontPropertyChange
     
    }//GEN-LAST:event_cmbFontPropertyChange


    /**
     * Respond to changes in the font size.
     *
     * <p>When the user changes the font size, the size in all displayed tabs
     * is updated.</p>
     *
     * @param evt
     */
    private void cmbFontActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cmbFontActionPerformed
        float size = 12f;

        try {
            size = Float.valueOf(this.cmbFont.getSelectedItem().toString());
        } catch (Exception e) {
            // ignore
        }

        List<TabPanel> tabs = ((MainWindow)this.getParent()).getTabList();
        for (TabPanel tab : tabs) {
            tab.updateFontSize(size);
        }
    }//GEN-LAST:event_cmbFontActionPerformed
    

    



    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnCancel;
    private javax.swing.JRadioButton btnHide;
    private javax.swing.JRadioButton btnMinimize;
    private javax.swing.JButton btnOk;
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JCheckBox cbxAlarm;
    private javax.swing.JCheckBox cbxUpdates;
    private javax.swing.JComboBox cmbFont;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JLabel lblHide;
    private javax.swing.JLabel lblTime;
    private javax.swing.JSpinner spnHour;
    private javax.swing.JSpinner spnMinute;
    // End of variables declaration//GEN-END:variables
    
    
}