/* Copyright 2006, Jeremy Brooks <jeremyb@whirljack.net>
 *
 * This file is part of Scrip du Jour.
 *
 * Scrip du Jour is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * Scrip du Jour is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with Foobar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package net.whirljack.sdj.gui;

// JAVA AWT
import java.awt.BorderLayout;
import java.awt.Rectangle;
import java.awt.SplashScreen;

// JAVA SWING
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JWindow;

/**
 * A splash window.
 * The logo is shown, and status can be updated.
 * The splash window is shown for at least two seconds.
 *
 * @author jeremyb
 */
public class SplashWindow extends JWindow {

    /** The window. */
    private static SplashWindow theWindow = null;

    /** The logo to display. */
    private static final String filename = "/net/whirljack/sdj/images/splash.png";

    /** The status. */
    private static JLabel lblStatus = null;


    /**
     * Build the window and make it visible.
     */
    private SplashWindow() {
        super();

        JLabel logo = new JLabel(new ImageIcon(getClass().getResource(filename)));
        lblStatus = new JLabel("Initializing...");
        getContentPane().add(logo, BorderLayout.CENTER);
        getContentPane().add(lblStatus, BorderLayout.SOUTH);
        pack();

	// replace the generic splash image with this window
	SplashScreen splash = SplashScreen.getSplashScreen();
	if (splash != null) {
	    Rectangle splashBounds = splash.getBounds();
	    this.setBounds(splashBounds);
	}
	
        setVisible(true);
    }


    /**
     * Get a reference to the window.
     * @return reference to the splash screen.
     */
    public static SplashWindow getInstance() {
        if (theWindow == null) {
            theWindow = new SplashWindow();
        }

        return theWindow;
    }


    /**
     * Request the splash screen to close.
     * When this is called, the splash screen will close, after making sure
     * that it has been visible for the minimum required time.
     */
    public void close() {
        setVisible(false);
        theWindow = null;
        dispose();
    }

    
    /**
     * Set the status label on the splash screen.
     *
     * @param status
     */
    public void setStatus(String status) {
        lblStatus.setText(status);
    }
}
