/* Copyright 2006, Jeremy Brooks <jeremyb@whirljack.net>
 *
 * This file is part of Scrip du Jour.
 *
 * Scrip du Jour is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * Scrip du Jour is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with Foobar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package net.whirljack.sdj.gui;

import java.awt.Frame;
import javax.swing.JDialog;

/**
 * Shows an animated progress bar, so the user knows something
 * is happening.
 *
 * @author  jeremyb
 */
public class WaitDialog extends JDialog {


    /**
     * Creates new form WaitDialog
     *
     * @param parent
     * @param modal
     * @param label
     */
    public WaitDialog(Frame parent, boolean modal, String label) {
        super(parent, modal);
        initComponents();
        this.jProgressBar1.setString(label);
        setSize(200, 80);
        setLocation(parent.getX() + ((parent.getWidth() - 200) / 2),
                parent.getY() + ((parent.getHeight() - 80) / 2));
    }

    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        jPanel1 = new javax.swing.JPanel();
        jProgressBar1 = new javax.swing.JProgressBar();

        getContentPane().setLayout(new java.awt.FlowLayout());

        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        setTitle("Please wait...");
        jPanel1.setLayout(new java.awt.GridLayout(0, 1));

        jProgressBar1.setIndeterminate(true);
        jProgressBar1.setString("working...");
        jProgressBar1.setStringPainted(true);
        jPanel1.add(jProgressBar1);

        getContentPane().add(jPanel1);

    }
    // </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel jPanel1;
    private javax.swing.JProgressBar jProgressBar1;
    // End of variables declaration//GEN-END:variables
}
